import code as c


# Example 1 - shows a valid and successful payment for a tv
def test_1():
    print('TEST 1')
    tv_item = c.Item(type='product', description='tv', amount=1000.00, quantity=1)
    payment = c.Item(type='payment', description='invoice_1', amount=1000.00, quantity=1)
    order = c.Order(id='1', items=[payment, tv_item])
    print(order)
    print("Result: ")
    print ("\t" + c.validorder(order))

# Example 2 - successfully detects negative payment imbalance as tv was never paid
def test_2():
    print('TEST 2')
    tv_item = c.Item(type='product', description='tv', amount=1000.00, quantity=1)
    order = c.Order(id='2', items=[tv_item])
    print(order)
    print("Result: ")
    print("\t" + c.validorder(order))

# Example 3 - successfully detects positive payment imbalance 
def test_3():
    print('TEST 3')
    tv_item = c.Item(type='product', description='tv', amount=1000.00, quantity=1)
    payment_1 = c.Item(type='payment', description='invoice_3_1', amount=700.00, quantity=1)
    payment_2 = c.Item(type='payment', description='invoice_3_2', amount=500.00, quantity=1)
    order = c.Order(id='3', items=[tv_item, payment_1, payment_2])
    print(order)
    print("Result: ")
    print("\t" + c.validorder(order))

# Example 4 - handles invalid input such as placing an invalid order for 1.5 device
def test_4():
    print('TEST 4')
    tv = c.Item(type='product', description='tv', amount=1000, quantity=1.5)
    order = c.Order(id='4', items=[tv])
    print(order)
    print("Result: ")
    print("\t" + c.validorder(order))

# Example 5 - handles an invalid item type called 'service'
def test_5():
    print('TEST 5')
    service = c.Item(type='service', description='order shipment', amount=100, quantity=1)
    order = c.Order(id='1', items=[service])
    print(order)
    print("Result: ")
    print("\t" + c.validorder(order))

# Example 6 - handles invalid input such as placing an invalid order for a negative quantity
def test_6():
    print('TEST 6')
    tv = c.Item(type='product', description='tv', amount=1000, quantity=-3)
    order = c.Order(id='6', items=[tv])
    print(order)
    print("Result: ")
    print("\t" + c.validorder(order))

test_1()
test_2()
test_3()
test_4()
test_5()
test_6()
