
For each of the following examples (JavaScript, PHP and Python):
1. Explain the behavior obtained when running the proposed code pattern.
2. Discuss its potential consequences in terms of **security** (when such a pattern is used in a larger application),
 possibly illustrating your point with some example.
 
## JavaScript

   
You can use this [online JSC interpreter](https://onecompiler.com/javascript)

	console.log('0'==0); 
	console.log(0=='0.0'); 
	console.log('0'=='0.0');

## PHP 

You can use this [online PHP interpreter](https://onecompiler.com/php)

### ex1:
   $x="2d8"; print (++$x."\n"); print (++$x."\n"); print (++$x."\n");

### ex2:
   if (0xf9 == "249e0") print ("True"); else print ("False");

## Python

	x = 0.1 + 0.2
    print(x)

## Java

Try to compile and run these two examples.
Explain the differences you obtain, telling the first example is rejected by Java.
Do you get the same results by replacing these Java codes by C codes ?
Why, and what do you conclude (from a security viewpoint) ?

### ex1:
	class exShort1 {
		public static void main(String[] args) {
			short x = 2
			System.out.println(x+1); 
			short z = x+1;
			System.out.println(z);
		}
	} 

### ex2:
	class exShort1 {
		public static void main(String[] args) {
			short x = 2
			System.out.println(x+1); 
			short z = x;
			System.out.println(z+1); 
		}
	} 

## C (argument evaluation)

Explain the behaviors obtained when running the 3 following C codes,
possibly using different compilers (gcc, clang, etc.).
What do you conclude ?

### ex1:
	#include <stdio.h>

	void main() {
		int c=0; 
		printf("%d %d\n",c++,c++); 
	}

### ex2:
	#include <stdio.h>

	void main() {
		int c=0; 
		printf("%d %d\n",++c,++c); 
	}

### ex3:
	#include <stdio.h>

	void main() {
		int c=0; 
		printf("%d %d\n",c=1,c=2); 
	}


## C (buffer overflow)

Explain the behaviors obtained when running the 3 following C codes,
possibly using different compilers (gcc, clang, etc.).
What do you conclude ?


### ex1:
	#include <stdio.h>

	int main() {
  		int i=2000;
  		int t[10] ;
  		t[10]=42;
  		printf("%d\n", t[10]) ;
  		printf("%d\n", i) ;
  		return 0 ;
	}


### ex1:
	#include <stdio.h>

	int main() {
  		int buf[256] ;
  		int t[16] ;
  		buf[0]=0;
  		t[16]=1;
  		printf("%d\n", t[16]) ;
  		printf("%d\n", buf[0]) ;
  		return 0 ;
	}
